﻿namespace Hims.Api.Senders
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.Library;

    using Hims.Api.Models.MailTemplates;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;

    /// <summary>
    /// The EmailSender interface.
    /// </summary>
    public interface IEmailSender
    {
        /// <summary>
        /// The send OTP async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<OTPResponse> SendOTPAsync(string email, string fullName);

        /// <summary>
        /// The send provider welcome mail async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <param name="createPasswordLink">
        /// The encrypted provider id.
        /// </param>
        /// <param name="roleName">
        /// The role Name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendCreatePasswordMailAsync(string email, string fullName, string createPasswordLink, string roleName);

        /// <summary>
        /// The send provider welcome mail async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendProviderWelcomeMailAsync(string email, string fullName);

        /// <summary>
        /// The send provider welcome mail async.
        /// </summary>
        /// <param name="doctorName">
        /// The full name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendMailAsync(string doctorName);

        /// <summary>
        /// The send patient welcome mail async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendPatientWelcomeMailAsync(string email, string fullName);

        /// <summary>The send book appointment mail async.</summary>
        /// <param name="email">The email.</param>
        /// <param name="patientName">The patient name.</param>
        /// <param name="accountName">The account name.</param>
        /// <param name="doctorName">The doctor name.</param>
        /// <param name="appointmentTime">The appointment time.</param>
        /// <param name="type">The type.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<bool> SendBookAppointmentMailAsync(string email, string patientName, string accountName, string doctorName, string appointmentTime, string type);

        /// <summary>
        /// The send welcome mail async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full Name.
        /// </param>
        /// <param name="password">
        /// The password.
        /// </param>
        /// <param name="createPasswordLink">
        /// The create Password Link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendWelcomeMailAsync(string email, string fullName, string password, string createPasswordLink);

        /// <summary>
        /// The reset password mail async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <param name="accountType">
        /// The account type.
        /// </param>
        /// <param name="resetPasswordLink">
        /// The reset password link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> ResetPasswordMailAsync(string email, string fullName, string accountType, string resetPasswordLink);

        /// <summary>
        /// The send payment mail async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <param name="paymentLink">
        /// The payment link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendPaymentMailAsync(string email, string fullName, string paymentLink);

        /// <summary>
        /// The send video link async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="fullName">
        /// The full name.
        /// </param>
        /// <param name="providerName">
        /// The provider name.
        /// </param>
        /// <param name="link">
        /// The link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendVideoLinkAsync(string email, string fullName, string providerName, string link);

        /// <summary>
        /// The send alert email to support.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendAlertEmailToSupport(IEnumerable<AccountModel> model);

        /// <summary>
        /// The send app links async.
        /// </summary>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendAppLinksAsync(string email);

        /// <summary>
        /// The send assign email to support.
        /// </summary>
        /// <param name="ticket">
        /// The ticket.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendAssignEmailToSupport(Tickets ticket);

        /// <summary>
        /// The send assign email to support.
        /// </summary>
        /// <param name="supportUsers">
        /// The ticket.
        /// </param>
        /// <param name="logfrom">
        /// </param>
        /// <param name="errorMessage">
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendExceptionLogEmailToSupport(IEnumerable<AccountModel> supportUsers, string logfrom, string errorMessage);
        

        /// The send assign email to support.
        /// </summary>
        /// <param name="supportUsers">
        /// The ticket.
        /// </param>
        /// <param name="logfrom">
        /// </param>

        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendPharmacyMailAsync(IEnumerable<AccountModel> emails, ProductEmailModel model);
        
        /// The send assign email to support.
        /// </summary>
        /// <param name="supportUsers">
        /// The ticket.
        /// </param>
        /// <param name="logfrom">
        /// </param>

        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendFinalBillEmailAsync(IEnumerable<AccountModel> emails, PharmacyBillReportModel model);
    }
}
